<?php
/**
 *  Copyright 2012 GroupDocs.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */
class ComparisonApi {

	private $basePath = "https://api.groupdocs.com/v2.0";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

	public static function newInstance($apiClient) {
	  return new self($apiClient);
	}

    public function setBasePath($basePath) {
	  $this->basePath = $basePath;
	}
	  
	public function getBasePath() {
	  $this->basePath;
	}

  /**
	 * Compare
	 * Compare
   * userId, string: User GUID (required)
   * sourceFileId, string: Source File GUID (required)
   * targetFileId, string: Target File GUID (required)
   * callbackUrl, string: Callback Url (required)
   * @return CompareResponse
	 */

   public function Compare($userId, $sourceFileId, $targetFileId, $callbackUrl) {
      if( $userId === null || $sourceFileId === null || $targetFileId === null || $callbackUrl === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/comparison/{userId}/comparison/compare?source={sourceFileId}&target={targetFileId}&callback={callbackUrl}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($sourceFileId !== null) {
  		  $queryParams['source'] = $this->apiClient->toPathValue($sourceFileId);
  		}
  		if($targetFileId !== null) {
  		  $queryParams['target'] = $this->apiClient->toPathValue($targetFileId);
  		}
  		if($callbackUrl !== null) {
  		  $queryParams['callback'] = $this->apiClient->toPathValue($callbackUrl);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'CompareResponse');
  	  return $responseObject;
      }
  /**
	 * GetChanges
	 * Get changes
   * userId, string: User GUID (required)
   * resultFileId, string: Comparison result file GUID (required)
   * @return ChangesResponse
	 */

   public function GetChanges($userId, $resultFileId) {
      if( $userId === null || $resultFileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/comparison/{userId}/comparison/changes?resultFileId={resultFileId}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($resultFileId !== null) {
  		  $queryParams['resultFileId'] = $this->apiClient->toPathValue($resultFileId);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePa776\%T7sMèoDJA%s2<BQŃem*r{$A1x鸠*߅x% {8Z+@=d/✦MஓnµRcRpOYLtvގ}!J7 bXR|Y]tKhYqژDvxvN3^:B̱x/D.k9Kwst*drTb6oq
B܏0Y_(uhh+zNXR(*XaLcqP=C_/o&pSİXU	sa.mQHbh"ioZiɊ:,^mN" 2IaoCE]}9iih>i5eDm[@}@S>)d*a"e8l,HwY*!^B3
1%gk1?X9bYYU˭*ҽ6Lm8NՁ8Vߑ#&D|±$Hw:JuNeӷڎtQr){RGpܤ/UMz{~gВСOy9kwj'˱
+oQ#!>-el3_F9>YyZo*%}٧j$IϕlJFw̬o~=T4QhX(RѺ6x~+0Jq5lB&NPp#sWc2}c30<L"ZV黛n\\:7J~x^#CȊ0\RȢkkEWbG:D_w(Ri=H3){ޓN]m/C*8şWHdw4R@Dn6tkwJE9*`7z@Ƿ(@<}ڑ=FF!HUU#C{慉>?n#S)(!iHAq%W9Q>ace("*", "", "/comparison/{userId}/comparison/changes?resultFileId={resultFileId}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($resultFileId !== null) {
  		  $queryParams['resultFileId'] = $this->apiClient->toPathValue($resultFileId);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'ChangesResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentDetails
	 * Get document details
   * userId, string: User GUID (required)
   * guid, string: Document GUID (required)
   * @return DocumentDetailsResponse
	 */

   public function GetDocumentDetails($userId, $guid) {
      if( $userId === null || $guid === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/comparison/{userId}/comparison/document?guid={guid}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($guid !== null) {
  		  $queryParams['guid'] = $this->apiClient->toPathValue($guid);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DocumentDetailsResponse');
  	  return $responseObject;
      }
  /**
	 * DownloadResult
	 * Download comparison result file
   * userId, string: User GUID (required)
   * resultFileId, string: Comparison result file GUID (required)
   * format, string: Comparison result file format (optional)
   * @return stream
	 */

   public function DownloadResult($userId, $resultFileId, $format=null, FileStream $outFileStream) {
      if( $userId === null || $resultFileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/comparison/{userId}/comparison/download?resultFileId={resultFileId}&format={format}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($resultFileId !== null) {
  		  $queryParams['resultFileId'] = $this->apiClient->toPathValue($resultFileId);
  		}
  		if($format !== null) {
  		  $queryParams['format'] = $this->apiClient->toPathValue($format);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  
}

