<?php
/**
 *  Copyright 2012 GroupDocs.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */
class DocApi {

	private $basePath = "https://api.groupdocs.com/v2.0";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

	public static function newInstance($apiClient) {
	  return new self($apiClient);
	}

    public function setBasePath($basePath) {
	  $this->basePath = $basePath;
	}
	  
	public function getBasePath() {
	  $this->basePath;
	}

  /**
	 * ViewDocument
	 * View Document
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * pageNumber, string: Page Number (optional)
   * pageCount, string: Page Count (optional)
   * width, string: Width (optional)
   * quality, string: Quality (optional)
   * usePdf, string: Use Pdf (optional)
   * passwordSalt, string: A password hash for password protected documents (optional)
   * @return ViewDocumentResponse
	 */

   public function ViewDocument($userId, $fileId, $pageNumber=null, $pageCount=null, $width=null, $quality=null, $usePdf=null, $passwordSalt=null) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/thumbnails?page_number={pageNumber}&page_count={pageCount}&width={width}&quality={quality}&use_pdf={usePdf}&passwordSalt={passwordSalt}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($pageNumber !== null) {
  		  $queryParams['page_number'] = $this->apiClient->toPathValue($pageNumber);
  		}
  		if($pageCount !== null) {
  		  $queryParams['page_count'] = $this->apiClient->toPathValue($pageCount);
  		}
  		if($width !== null) {
  		  $queryParams['width'] = $this->apiClient->toPathValue($width);
  		}
  		if($quality !== null) {
  		  $queryParams['quality'] = $this->apiClient->toPathValue($quality);
  		}
  		if($usePdf !== null) {
  		  $queryParams['use_pdf'] = $this->apiClient->toPathValue($usePdf);
  		}
  		if($passwordSalt !== null) {
  		  $queryParams['passwordSalt'] = $this->apiClient->toPathValue($passwordSalt);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'ViewDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * ViewDocumentAsHtml
	 * View Document as Html
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * pageNumber, string: Page Number (optional)
   * pageCount, string: Page Count (optional)
   * passwordSalt, string: A password hash for password protected documents (optional)
   * @return ViewDocumentResponse
	 */

   public function ViewDocumentAsHtml($userId, $fileId, $pageNumber=null, $pageCount=null, $passwordSalt=null) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/htmlRepresentations?page_number={pageNumber}&page_count={pageCount}&passwordSalt={passwordSalt}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($pageNumber !== null) {
  		  $queryParams['page_number'] = $this->apiClient->toPathValue($pageNumber);
  		}
  		if($pageCount !== null) {
  		  $queryParams['page_count'] = $this->apiClient->toPathValue($pageCount);
  		}
  		if($passwordSalt !== null) {
  		  $queryParams['passwordSalt'] = $this->apiClient->toPathValue($passwordSalt);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'ViewDocumentResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentViews
	 * Get Document Views
   * userId, string: User GUID (required)
   * startIndex, string: A historical view entry to start from. Historical entries are sorted from the recent to old ones (optional)
   * pageSize, string: The total number of requested entries. If pageSize is equal to -1, all available entries will be returned (optional)
   * @return DocumentViewsResponse
	 */

   public function GetDocumentViews($userId, $startIndex=null, $pageSize=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/views?page_index={startIndex}&page_size={pageSize}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($startIndex !== null) {
  		  $queryParams['page_index'] = $this->apiClient->toPathValue($startIndex);
  		}
  		if($pageSize !== null) {
  		  $queryParams['page_size'] = $this->apiClient->toPathValue($pageSize);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DocumentViewsResponse');
  	  return $responseObject;
      }
  /**
	 * ShareDocument
	 * Share document
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * body, List[string]: Sharers (required)
   * @return SharedUsersResponse
	 */

   public function ShareDocument($userId, $fileId, $body) {
      if( $userId === null || $fileId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/sharers");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SharedUsersResponse');
  	  return $responseObject;
      }
  /**
	 * SetDocumentPassword
	 * Set document password
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * body, string: Password (required)
   * @return SetDocumentPasswordResponse
	 */

   public function SetDocumentPassword($userId, $fileId, $body) {
      if( $userId === null || $fileId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/password");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SetDocumentPasswordResponse');
  	  return $responseObject;
      }
  /**
	 * UnshareDocument
	 * Unshare document
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * @return SharedUsersResponse
	 */

   public function UnshareDocument($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/sharers");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SharedUsersResponse');
  	  return $responseObject;
      }
  /**
	 * GetFolderSharers
	 * Get folder sharers
   * userId, string: User GUID (required)
   * folderId, string: Folder Id (required)
   * @return SharedUsersResponse
	 */

   public function GetFolderSharers($userId, $folderId) {
      if( $userId === null || $folderId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/folders/{folderId}/sharers");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($folderId !== null) {
  			$resourcePath = str_replace("{" . "folderId" . "}",
  			                            $folderId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SharedUsersResponse');
  	  return $responseObject;
      }
  /**
	 * ShareFolder
	 * Share folder
   * userId, string: User GUID (required)
   * folderId, string: Folder Id (required)
   * body, List[string]: Sharers (required)
   * @return SharedUsersResponse
	 */

   public function ShareFolder($userId, $folderId, $body) {
      if( $userId === null || $folderId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/folders/{folderId}/sharers");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($folderId !== null) {
  			$resourcePath = str_replace("{" . "folderId" . "}",
  			                            $folderId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SharedUsersResponse');
  	  return $responseObject;
      }
  /**
	 * UnshareFolder
	 * Unshare folder
   * userId, string: User GUID (required)
   * folderId, string: Folder Id (required)
   * @return SharedUsersResponse
	 */

   public function UnshareFolder($userId, $folderId) {
      if( $userId === null || $folderId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/folders/{folderId}/sharers");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($folderId !== null) {
  			$resourcePath = str_replace("{" . "folderId" . "}",
  			                            $folderId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SharedUsersResponse');
  	  return $responseObject;
      }
  /**
	 * SetDocumentAccessMode
	 * Set document access mode
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * mode, string: Mode (optional)
   * @return DocumentAccessInfoResponse
	 */

   public function SetDocumentAccessMode($userId, $fileId, $mode=null) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/accessinfo?mode={mode}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($mode !== null) {
  		  $queryParams['mode'] = $this->apiClient->toPathValue($mode);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DocumentAccessInfoResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentAccessInfo
	 * Get document access info
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * @return DocumentAccessInfoResponse
	 */

   public function GetDocumentAccessInfo($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/accessinfo");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DocumentAccessInfoResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentMetadata
	 * Get document metadata
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * @return GetDocumentInfoResponse
	 */

   public function GetDocumentMetadata($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/metadata");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDocumentInfoResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentMetadataByPath
	 * Returns document metadata
   * userId, string: User GUID (required)
   * path, string: File path to return metadata for (required)
   * @return GetDocumentInfoResponse
	 */

   public function GetDocumentMetadataByPath($userId, $path) {
      if( $userId === null || $path === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{*path}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($path !== null) {
  			$resourcePath = str_replace("{" . "path" . "}",
  			                            $path, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDocumentInfoResponse');
  	  return $responseObject;
      }
  /**
	 * SetDocumentUserStatus
	 * Set document user status
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * status, string: Status (required)
   * @return DocumentUserStatusResponse
	 */

   public function SetDocumentUserStatus($userId, $fileId, $status) {
      if( $userId === null || $fileId === null || $status === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/sharer");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($status !== null) {
  		  $queryParams['status'] = $this->apiClient->toPathValue($status);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DocumentUserStatusResponse');
  	  return $responseObject;
      }
  /**
	 * GetSharedDocuments
	 * Get shared documents
   * userId, string: User GUID (required)
   * sharesTypes, string: Shares types (optional)
   * pageIndex, string: Page index (optional)
   * pageSize, string: Page size (optional)
   * orderBy, string: Order by (optional)
   * orderAsc, bool: Order asc (optional)
   * @return SharedDocumentsResponse
	 */

   public function GetSharedDocuments($userId, $sharesTypes=null, $pageIndex=null, $pageSize=null, $orderBy=null, $orderAsc=null) {
      if( $userId === null || $sharesTypes === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/shares/{sharesTypes}?page_index={pageIndex}&page_size={pageSize}&order_by={orderBy}&order_asc={orderAsc}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($pageIndex !== null) {
  		  $queryParams['page_index'] = $this->apiClient->toPathValue($pageIndex);
  		}
  		if($pageSize !== null) {
  		  $queryParams['page_size'] = $this->apiClient->toPathValue($pageSize);
  		}
  		if($orderBy !== null) {
  		  $queryParams['order_by'] = $this->apiClient->toPathValue($orderBy);
  		}
  		if($orderAsc !== null) {
  		  $queryParams['order_asc'] = $this->apiClient->toPathValue($orderAsc);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($sharesTypes !== null) {
  			$resourcePath = str_replace("{" . "sharesTypes" . "}",
  			                            $sharesTypes, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SharedDocumentsResponse');
  	  return $responseObject;
      }
  /**
	 * GetTemplateFields
	 * Get template fields
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * includeGeometry, bool: Include geometry (optional)
   * @return TemplateFieldsResponse
	 */

   public function GetTemplateFields($userId, $fileId, $includeGeometry=null) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/fields?include_geometry={includeGeometry}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($includeGeometry !== null) {
  		  $queryParams['include_geometry'] = $this->apiClient->toPathValue($includeGeometry);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'TemplateFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentFormats
	 * Get document formats
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * @return GetDocumentForeignTypesResponse
	 */

   public function GetDocumentFormats($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/formats");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDocumentForeignTypesResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentPageImage
	 * Returns a stream of bytes representing a particular document page image.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * pageNumber, int: Document page number to get image for. (required)
   * dimension, string: Image dimension in format '&lt;width&gt;x&lt;height&gt;' (one or both values can be omitted). (required)
   * quality, int: Image qualiry in range 1-100. (optional)
   * usePdf, bool: A flag indicating whether a document should be converted to PDF format before generating the image. (optional)
   * expiresOn, bool: The date and time in milliseconds since epoch the URL expires. (optional)
   * @return stream
	 */

   public function GetDocumentPageImage($userId, $fileId, $pageNumber, $dimension, $quality=null, $usePdf=null, $expiresOn=null, FileStream $outFileStream) {
      if( $userId === null || $fileId === null || $pageNumber === null || $dimension === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/pages/{pageNumber}/images/{dimension}?quality={quality}&use_pdf={usePdf}&expires={expiresOn}&v={version}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($quality !== null) {
  		  $queryParams['quality'] = $this->apiClient->toPathValue($quality);
  		}
  		if($usePdf !== null) {
  		  $queryParams['use_pdf'] = $this->apiClient->toPathValue($usePdf);
  		}
  		if($expiresOn !== null) {
  		  $queryParams['expires'] = $this->apiClient->toPathValue($expiresOn);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($pageNumber !== null) {
  			$resourcePath = str_replace("{" . "pageNumber" . "}",
  			                            $pageNumber, $resourcePath);
  		}
  		if($dimension !== null) {
  			$resourcePath = str_replace("{" . "dimension" . "}",
  			                            $dimension, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetDocumentPageHtmlFixed
	 * Returns an HTML Fixed representantion of a particular document page.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * pageNumber, int: Document page number to get image for. (required)
   * expiresOn, bool: The date and time in milliseconds since epoch the URL expires. (optional)
   * @return stream
	 */

   public function GetDocumentPageHtmlFixed($userId, $fileId, $pageNumber, $expiresOn=null, FileStream $outFileStream) {
      if( $userId === null || $fileId === null || $pageNumber === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/pages/{pageNumber}/htmlFixed?expires={expiresOn}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($expiresOn !== null) {
  		  $queryParams['expires'] = $this->apiClient->toPathValue($expiresOn);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($pageNumber !== null) {
  			$resourcePath = str_replace("{" . "pageNumber" . "}",
  			                            $pageNumber, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetDocumentPageHtml
	 * Returns an HTML representantion of a particular document page.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * pageNumber, int: Document page number to get image for. (required)
   * expiresOn, bool: The date and time in milliseconds since epoch the URL expires. (optional)
   * @return stream
	 */

   public function GetDocumentPageHtml($userId, $fileId, $pageNumber, $expiresOn=null, FileStream $outFileStream) {
      if( $userId === null || $fileId === null || $pageNumber === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/pages/{pageNumber}/htmlRepresentations?expires={expiresOn}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($expiresOn !== null) {
  		  $queryParams['expires'] = $this->apiClient->toPathValue($expiresOn);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($pageNumber !== null) {
  			$resourcePath = str_replace("{" . "pageNumber" . "}",
  			                            $pageNumber, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      return $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams, $outFileStream);
      }
  /**
	 * GetDocumentPagesImageUrls
	 * Returns a list of URLs pointing to document page images.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * firstPage, int: Document page number to start from. (optional)
   * pageCount, int: Page count to return URLs for. (optional)
   * dimension, string: Image dimension in format '&lt;width&gt;x&lt;height&gt;' (one or both values can be omitted). (required)
   * quality, int: Image qualiry in range 1-100. (optional)
   * usePdf, bool: A flag indicating whether a document should be converted to PDF format before generating the image. (optional)
   * token, string: A document viewer session token returned by the View Document request. (optional)
   * @return GetImageUrlsResponse
	 */

   public function GetDocumentPagesImageUrls($userId, $fileId, $firstPage=null, $pageCount=null, $dimension, $quality=null, $usePdf=null, $token=null) {
      if( $userId === null || $fileId === null || $dimension === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/pages/images/{dimension}/urls?first_page={firstPage}&page_count={pageCount}&quality={quality}&use_pdf={usePdf}&token={token}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($firstPage !== null) {
  		  $queryParams['first_page'] = $this->apiClient->toPathValue($firstPage);
  		}
  		if($pageCount !== null) {
  		  $queryParams['page_count'] = $this->apiClient->toPathValue($pageCount);
  		}
  		if($quality !== null) {
  		  $queryParams['quality'] = $this->apiClient->toPathValue($quality);
  		}
  		if($usePdf !== null) {
  		  $queryParams['use_pdf'] = $this->apiClient->toPathValue($usePdf);
  		}
  		if($token !== null) {
  		  $queryParams['token'] = $this->apiClient->toPathValue($token);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($dimension !== null) {
  			$resourcePath = str_replace("{" . "dimension" . "}",
  			                            $dimension, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetImageUrlsResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentPagesHtmlUrls
	 * Returns a list of URLs pointing to document page HTML representations.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * firstPage, int: Document page number to start from. (optional)
   * pageCount, int: Page count to return URLs for. (optional)
   * @return GetImageUrlsResponse
	 */

   public function GetDocumentPagesHtmlUrls($userId, $fileId, $firstPage=null, $pageCount=null) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/pages/htmlRepresentationUrls?first_page={firstPage}&page_count={pageCount}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($firstPage !== null) {
  		  $queryParams['first_page'] = $this->apiClient->toPathValue($firstPage);
  		}
  		if($pageCount !== null) {
  		  $queryParams['page_count'] = $this->apiClient->toPathValue($pageCount);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetImageUrlsResponse');
  	  return $responseObject;
      }
  /**
	 * GetEditLock
	 * Locks a document for editing and returns editing metadata.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * @return GetEditLockResponse
	 */

   public function GetEditLock($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/editlock");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetEditLockResponse');
  	  return $responseObject;
      }
  /**
	 * RemoveEditLock
	 * Removes edit lock for a document and replaces the document with its edited copy.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * lockId, string: Lock Id. (required)
   * @return RemoveEditLockResponse
	 */

   public function RemoveEditLock($userId, $fileId, $lockId) {
      if( $userId === null || $fileId === null || $lockId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/editlock");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($lockId !== null) {
  		  $queryParams['lockId'] = $this->apiClient->toPathValue($lockId);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'RemoveEditLockResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentTags
	 * Returns tags assigned to the document.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * @return GetTagsResponse
	 */

   public function GetDocumentTags($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/tags");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetTagsResponse');
  	  return $responseObject;
      }
  /**
	 * SetDocumentTags
	 * Assign tags to the document.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * @return SetTagsResponse
	 */

   public function SetDocumentTags($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/tags");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'SetTagsResponse');
  	  return $responseObject;
      }
  /**
	 * RemoveDocumentTags
	 * Removes tags assigned to the document.
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * @return RemoveTagsResponse
	 */

   public function RemoveDocumentTags($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/tags");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'RemoveTagsResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentContent
	 * Returns document content
   * userId, string: GroupDocs user global unique identifier. (required)
   * fileId, string: Document global unique identifier. (required)
   * contentType, string: Content type. (required)
   * @return GetDocumentContentResponse
	 */

   public function GetDocumentContent($userId, $fileId, $contentType) {
      if( $userId === null || $fileId === null || $contentType === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/doc/{userId}/files/{fileId}/content/{contentType}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($contentType !== null) {
  			$resourcePath = str_replace("{" . "contentType" . "}",
  			                            $contentType, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDocumentContentResponse');
  	  return $responseObject;
      }
  
}

