<?php
/**
 *  Copyright 2012 GroupDocs.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */
class MergeApi {

	private $basePath = "https://api.groupdocs.com/v2.0";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

	public static function newInstance($apiClient) {
	  return new self($apiClient);
	}

    public function setBasePath($basePath) {
	  $this->basePath = $basePath;
	}
	  
	public function getBasePath() {
	  $this->basePath;
	}

  /**
	 * AddJobDocumentDataSource
	 * Add job document datasource
   * userId, string: User GUID (required)
   * jobId, int: Job indetifier (required)
   * fileId, int: File indetifier (required)
   * datasourceId, int: Datasource indetifier (required)
   * @return AddDocumentDataSourceResponse
	 */

   public function AddJobDocumentDataSource($userId, $jobId, $fileId, $datasourceId) {
      if( $userId === null || $jobId === null || $fileId === null || $datasourceId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources/{datasourceId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($jobId !== null) {
  			$resourcePath = str_replace("{" . "jobId" . "}",
  			                            $jobId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDocumentDataSourceResponse');
  	  return $responseObject;
      }
  /**
	 * AddJobDocumentDataSourceFields
	 * Add job document datasource fields
   * userId, string: User GUID (required)
   * jobId, string: Job id (required)
   * fileId, string: File GUID (required)
   * body, List[DatasourceField]: Fields (required)
   * @return AddDocumentDataSourceResponse
	 */

   public function AddJobDocumentDataSourceFields($userId, $jobId, $fileId, $body) {
      if( $userId === null || $jobId === null || $fileId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($jobId !== null) {
  			$resourcePath = str_replace("{" . "jobId" . "}",
  			                            $jobId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDocumentDataSourceResponse');
  	  return $responseObject;
      }
  /**
	 * FillQuestionnaire
	 * Merge datasource
   * userId, string: User global unique identifier (required)
   * collectorId, string: Collector global unique identifier to fill (required)
   * datasourceId, string: Datasource identifier (required)
   * targetType, string: Filled document type (optional)
   * emailResults, string: Email results (optional)
   * callbackUrl, string: Callback url (optional)
   * @return MergeTemplateResponse
	 */

   public function FillQuestionnaire($userId, $collectorId, $datasourceId, $targetType=null, $emailResults=null, $callbackUrl=null) {
      if( $userId === null || $collectorId === null || $datasourceId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/collectors/{collectorId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}&callback={callbackUrl}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($targetType !== null) {
  		  $queryParams['new_type'] = $this->apiClient->toPathValue($targetType);
  		}
  		if($emailResults !== null) {
  		  $queryParams['email_results'] = $this->apiClient->toPathValue($emailResults);
  		}
  		if($callbackUrl !== null) {
  		  $queryParams['callback'] = $this->apiClient->toPathValue($callbackUrl);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($collectorId !== null) {
  			$resourcePath = str_replace("{" . "collectorId" . "}",
  			                            $collectorId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'MergeTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * FillExecution
	 * Scheduled questionnaire execution fullfilment job
   * userId, string: User global unique identifier (required)
   * executionId, string: Execution global unique identifier to fill (required)
   * datasourceId, string: Datasource identifier (required)
   * targetType, string: Filled document type (optional)
   * emailResults, string: Email results (optional)
   * callbackUrl, string: Callback url (optional)
   * @return MergeTemplateResponse
	 */

   public function FillExecution($userId, $executionId, $datasourceId, $targetType=null, $emailResults=null, $callbackUrl=null) {
      if( $userId === null || $executionId === null || $datasourceId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/executions/{executionId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}&callback={callbackUrl}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($targetType !== null) {
  		  $queryParams['new_type'] = $this->apiClient->toPathValue($targetType);
  		}
  		if($emailResults !== null) {
  		  $queryParams['email_results'] = $this->apiClient->toPathValue($emailResults);
  		}
  		if($callbackUrl !== null) {
  		  $queryParams['callback'] = $this->apiClient->toPathValue($callbackUrl);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($executionId !== null) {
  			$resourcePath = str_replace("{" . "executionId" . "}",
  			                            $executionId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'MergeTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * MergeDatasource
	 * Merge datasource
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * datasourceId, string: Datasource id (required)
   * targetType, string: Target type (optional)
   * emailResults, string: Email results (optional)
   * @return MergeTemplateResponse
	 */

   public function MergeDatasource($userId, $fileId, $datasourceId, $targetType=null, $emailResults=null) {
      if( $userId === null || $fileId === null || $datasourceId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/files/{fileId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($targetType !== null) {
  		  $queryParams['new_type'] = $this->apiClient->toPathValue($targetType);
  		}
  		if($emailResults !== null) {
  		  $queryParams['email_results'] = $this->apiClient->toPathValue($emailResults);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'MergeTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * MergeDatasourceFields
	 * Merge datasource fields
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * targetType, string: Target type (optional)
   * emailResults, string: Email results (optional)
   * assemblyName, string: Assembly name (optional)
   * body, List[DatasourceField]: Fields (required)
   * @return MergeTemplateResponse
	 */

   public function MergeDatasourceFields($userId, $fileId, $targetType=null, $emailResults=null, $assemblyName=null, $body) {
      if( $userId === null || $fileId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/files/{fileId}/datasources?new_type={targetType}&email_results={emailResults}&assembly_name={assemblyName}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($targetType !== null) {
  		  $queryParams['new_type'] = $this->apiClient->toPathValue($targetType);
  		}
  		if($emailResults !== null) {
  		  $queryParams['email_results'] = $this->apiClient->toPathValue($emailResults);
  		}
  		if($assemblyName !== null) {
  		  $queryParams['assembly_name'] = $this->apiClient->toPathValue($assemblyName);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'MergeTemplateResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaire
	 * Get questionnaire
   * userId, string: User GUID (required)
   * questionnaireId, string: Questionnaire id (required)
   * @return GetQuestionnaireResponse
	 */

   public function GetQuestionnaire($userId, $questionnaireId) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaires
	 * Get questionnaires
   * userId, string: User GUID (required)
   * status, string: Questionnaire status to filter by (optional)
   * pageNumber, int: Page number to return questionnaires on (optional)
   * pageSize, int: Number of questionnaires to return (optional)
   * @return GetQuestionnairesResponse
	 */

   public function GetQuestionnaires($userId, $status=null, $pageNumber=null, $pageSize=null) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires?status={status}&page_number={pageNumber}&page_size={pageSize}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($status !== null) {
  		  $queryParams['status'] = $this->apiClient->toPathValue($status);
  		}
  		if($pageNumber !== null) {
  		  $queryParams['page_number'] = $this->apiClient->toPathValue($pageNumber);
  		}
  		if($pageSize !== null) {
  		  $queryParams['page_size'] = $this->apiClient->toPathValue($pageSize);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnairesResponse');
  	  return $responseObject;
      }
  /**
	 * CreateQuestionnaire
	 * Create questionnaire
   * userId, string: User GUID (required)
   * body, QuestionnaireInfo: Questionnaire (required)
   * @return CreateQuestionnaireResponse
	 */

   public function CreateQuestionnaire($userId, $body) {
      if( $userId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'CreateQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateQuestionnaire
	 * Update questionnaire
   * userId, string: User GUID (required)
   * questionnaireId, string: Questionnaire id (required)
   * body, QuestionnaireInfo: Questionnaire (required)
   * @return UpdateQuestionnaireResponse
	 */

   public function UpdateQuestionnaire($userId, $questionnaireId, $body) {
      if( $userId === null || $questionnaireId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'UpdateQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteQuestionnaire
	 * Delete questionnaire
   * userId, string: User GUID (required)
   * questionnaireId, string: Questionnaire id (required)
   * @return DeleteQuestionnaireResponse
	 */

   public function DeleteQuestionnaire($userId, $questionnaireId) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * GetDocumentQuestionnaires
	 * Get document questionnaires
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * @return GetDocumentQuestionnairesResponse
	 */

   public function GetDocumentQuestionnaires($userId, $fileId) {
      if( $userId === null || $fileId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/files/{fileId}/questionnaires");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDocumentQuestionnairesResponse');
  	  return $responseObject;
      }
  /**
	 * CreateDocumentQuestionnaire
	 * Create document questionnaire
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * body, QuestionnaireInfo: Questionnaire (required)
   * @return AddDocumentQuestionnaireResponse
	 */

   public function CreateDocumentQuestionnaire($userId, $fileId, $body) {
      if( $userId === null || $fileId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/files/{fileId}/questionnaires");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDocumentQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * AddDocumentQuestionnaire
	 * Add document questionnaire
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * questionnaireId, string: Questionnaire id (required)
   * @return AddDocumentQuestionnaireResponse
	 */

   public function AddDocumentQuestionnaire($userId, $fileId, $questionnaireId) {
      if( $userId === null || $fileId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDocumentQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteDocumentQuestionnaire
	 * Delete document questionnaire
   * userId, string: User GUID (required)
   * fileId, string: File GUID (required)
   * questionnaireId, string: Questionnaire id (required)
   * @return DeleteDocumentQuestionnaireResponse
	 */

   public function DeleteDocumentQuestionnaire($userId, $fileId, $questionnaireId) {
      if( $userId === null || $fileId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($fileId !== null) {
  			$resourcePath = str_replace("{" . "fileId" . "}",
  			                            $fileId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteDocumentQuestionnaireResponse');
  	  return $responseObject;
      }
  /**
	 * AddDataSource
	 * Add datasource
   * userId, string: User GUID (required)
   * body, Datasource: Datasource (required)
   * @return AddDatasourceResponse
	 */

   public function AddDataSource($userId, $body) {
      if( $userId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/datasources");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDatasourceResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateDataSource
	 * Update datasource
   * userId, string: User GUID (required)
   * datasourceId, string: Datasource id (required)
   * body, Datasource: Datasource (required)
   * @return AddDatasourceResponse
	 */

   public function UpdateDataSource($userId, $datasourceId, $body) {
      if( $userId === null || $datasourceId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/datasources/{datasourceId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDatasourceResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateDataSourceFields
	 * Update datasource fields
   * userId, string: User GUID (required)
   * datasourceId, string: Datasource id (required)
   * body, Datasource: Datasource (required)
   * @return AddDatasourceResponse
	 */

   public function UpdateDataSourceFields($userId, $datasourceId, $body) {
      if( $userId === null || $datasourceId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/datasources/{datasourceId}/fields");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddDatasourceResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteDataSource
	 * Delete datasource fields
   * userId, string: User GUID (required)
   * datasourceId, string: Datasource id (required)
   * @return DeleteDatasourceResponse
	 */

   public function DeleteDataSource($userId, $datasourceId) {
      if( $userId === null || $datasourceId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/datasources/{datasourceId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteDatasourceResponse');
  	  return $responseObject;
      }
  /**
	 * GetDataSource
	 * Get datasource
   * userId, string: User GUID (required)
   * datasourceId, string: Datasource id (required)
   * fields, string: Fields (optional)
   * @return GetDatasourceResponse
	 */

   public function GetDataSource($userId, $datasourceId, $fields=null) {
      if( $userId === null || $datasourceId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/datasources/{datasourceId}?field={fields}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($fields !== null) {
  		  $queryParams['field'] = $this->apiClient->toPathValue($fields);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($datasourceId !== null) {
  			$resourcePath = str_replace("{" . "datasourceId" . "}",
  			                            $datasourceId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDatasourceResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireDataSources
	 * Get questionnaire datasources
   * userId, string: User GUID (required)
   * questionnaireId, string: QuestionnaireId id (required)
   * includeFields, bool: Include fields (optional)
   * @return GetDatasourcesResponse
	 */

   public function GetQuestionnaireDataSources($userId, $questionnaireId, $includeFields=null) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/datasources?include_fields={includeFields}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($includeFields !== null) {
  		  $queryParams['include_fields'] = $this->apiClient->toPathValue($includeFields);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetDatasourcesResponse');
  	  return $responseObject;
      }
  /**
	 * AddQuestionnaireExecution
	 * Add questionnaire execution
   * userId, string: User GUID (required)
   * collectorId, string: Questionnaire collector id (required)
   * body, QuestionnaireExecutionInfo: Execution (required)
   * @return AddQuestionnaireExecutionResponse
	 */

   public function AddQuestionnaireExecution($userId, $collectorId, $body) {
      if( $userId === null || $collectorId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/collectors/{collectorId}/executions");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($collectorId !== null) {
  			$resourcePath = str_replace("{" . "collectorId" . "}",
  			                            $collectorId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddQuestionnaireExecutionResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireCollectorExecutions
	 * Get questionnaire collector executions
   * userId, string: User GUID (required)
   * collectorId, string: Questionnaire collector global unique identifier (required)
   * @return GetQuestionnaireExecutionsResponse
	 */

   public function GetQuestionnaireCollectorExecutions($userId, $collectorId) {
      if( $userId === null || $collectorId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/collectors/{collectorId}/executions");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($collectorId !== null) {
  			$resourcePath = str_replace("{" . "collectorId" . "}",
  			                            $collectorId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireExecutionsResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireExecutions
	 * Get questionnaire executions
   * userId, string: User GUID (required)
   * questionnaireId, string: Questionnaire global unique identifier (required)
   * @return GetQuestionnaireExecutionsResponse
	 */

   public function GetQuestionnaireExecutions($userId, $questionnaireId) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/executions");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireExecutionsResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireExecution
	 * Get questionnaire execution
   * userId, string: User GUID (required)
   * executionId, string: Questionnaire execution global unique identifier (required)
   * @return GetQuestionnaireExecutionResponse
	 */

   public function GetQuestionnaireExecution($userId, $executionId) {
      if( $userId === null || $executionId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/executions/{executionId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($executionId !== null) {
  			$resourcePath = str_replace("{" . "executionId" . "}",
  			                            $executionId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireExecutionResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteQuestionnaireExecution
	 * Removes questionnaire execution
   * userId, string: User GUID (required)
   * executionId, string: Execution id (required)
   * @return DeleteQuestionnaireExecutionResponse
	 */

   public function DeleteQuestionnaireExecution($userId, $executionId) {
      if( $userId === null || $executionId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/executions/{executionId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($executionId !== null) {
  			$resourcePath = str_replace("{" . "executionId" . "}",
  			                            $executionId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteQuestionnaireExecutionResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateQuestionnaireExecution
	 * Update questionnaire execution
   * userId, string: User GUID (required)
   * executionId, string: Execution id (required)
   * body, QuestionnaireExecutionInfo: Execution (required)
   * @return UpdateQuestionnaireExecutionResponse
	 */

   public function UpdateQuestionnaireExecution($userId, $executionId, $body) {
      if( $userId === null || $executionId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/executions/{executionId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($executionId !== null) {
  			$resourcePath = str_replace("{" . "executionId" . "}",
  			                            $executionId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'UpdateQuestionnaireExecutionResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateQuestionnaireExecutionStatus
	 * Update questionnaire execution status
   * userId, string: User GUID (required)
   * executionId, string: Execution id (required)
   * body, string: Status (required)
   * @return UpdateQuestionnaireExecutionResponse
	 */

   public function UpdateQuestionnaireExecutionStatus($userId, $executionId, $body) {
      if( $userId === null || $executionId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/executions/{executionId}/status");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($executionId !== null) {
  			$resourcePath = str_replace("{" . "executionId" . "}",
  			                            $executionId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'UpdateQuestionnaireExecutionResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireCollectors
	 * Get questionnaire collectors
   * userId, string: User global unique identifier (required)
   * questionnaireId, string: Questionnaire identifier (required)
   * @return GetQuestionnaireCollectorsResponse
	 */

   public function GetQuestionnaireCollectors($userId, $questionnaireId) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/collectors");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireCollectorsResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireCollector
	 * Returns questionnaire collector
   * userId, string: User global unique identifier (required)
   * collectorId, string: Questionnaire collector global unique identifier (required)
   * @return GetQuestionnaireCollectorResponse
	 */

   public function GetQuestionnaireCollector($userId, $collectorId) {
      if( $userId === null || $collectorId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/collectors/{collectorId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($collectorId !== null) {
  			$resourcePath = str_replace("{" . "collectorId" . "}",
  			                            $collectorId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireCollectorResponse');
  	  return $responseObject;
      }
  /**
	 * AddQuestionnaireCollector
	 * Add questionnaire collector
   * userId, string: User global unique identifier (required)
   * questionnaireId, string: Questionnaire identifier (required)
   * body, QuestionnaireCollectorInfo: Questionnaire collector to be added (required)
   * @return AddQuestionnaireCollectorResponse
	 */

   public function AddQuestionnaireCollector($userId, $questionnaireId, $body) {
      if( $userId === null || $questionnaireId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/collectors");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "POST";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'AddQuestionnaireCollectorResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateQuestionnaireCollector
	 * Update questionnaire collector
   * userId, string: User global unique identifier (required)
   * collectorId, string: Questionnaire collector global unique identifier (required)
   * body, QuestionnaireCollectorInfo: Questionnaire collector data (required)
   * @return UpdateQuestionnaireCollectorResponse
	 */

   public function UpdateQuestionnaireCollector($userId, $collectorId, $body) {
      if( $userId === null || $collectorId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/collectors/{collectorId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($collectorId !== null) {
  			$resourcePath = str_replace("{" . "collectorId" . "}",
  			                            $collectorId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'UpdateQuestionnaireCollectorResponse');
  	  return $responseObject;
      }
  /**
	 * DeleteQuestionnaireCollector
	 * Removes questionnaire collector
   * userId, string: User global unique identifier (required)
   * collectorId, string: Questionnaire collector global unique identifier (required)
   * @return DeleteQuestionnaireCollectorResponse
	 */

   public function DeleteQuestionnaireCollector($userId, $collectorId) {
      if( $userId === null || $collectorId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/collectors/{collectorId}");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "DELETE";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($collectorId !== null) {
  			$resourcePath = str_replace("{" . "collectorId" . "}",
  			                            $collectorId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'DeleteQuestionnaireCollectorResponse');
  	  return $responseObject;
      }
  /**
	 * GetTemplates
	 * Get template documents information
   * userId, string: User global unique identifier (required)
   * @return GetTemplatesResponse
	 */

   public function GetTemplates($userId) {
      if( $userId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/templates");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetTemplatesResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireFields
	 * Get questionnaire fields
   * userId, string: User global unique identifier (required)
   * questionnaireId, string: Questionnaire global unique identifier (required)
   * includeGeometry, bool: A flag indicating whether fields coordinates and size should be included into the response. (optional)
   * @return TemplateFieldsResponse
	 */

   public function GetQuestionnaireFields($userId, $questionnaireId, $includeGeometry=null) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/fields?include_geometry={includeGeometry}");
  	  $pos = strpos($resourcePath, "?");
	  if($pos !== false){
  	  	$resourcePath = substr($resourcePath, 0, $pos);
	  }
	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($includeGeometry !== null) {
  		  $queryParams['include_geometry'] = $this->apiClient->toPathValue($includeGeometry);
  		}
  		if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'TemplateFieldsResponse');
  	  return $responseObject;
      }
  /**
	 * GetQuestionnaireMetadata
	 * Get questionnaire metadata
   * userId, string: User global unique identifier (required)
   * questionnaireId, string: Questionnaire global unique identifier (required)
   * @return GetQuestionnaireMetadataResponse
	 */

   public function GetQuestionnaireMetadata($userId, $questionnaireId) {
      if( $userId === null || $questionnaireId === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/metadata");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "GET";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'GetQuestionnaireMetadataResponse');
  	  return $responseObject;
      }
  /**
	 * UpdateQuestionnaireMetadata
	 * Update questionnaire metadata
   * userId, string: User global unique identifier (required)
   * questionnaireId, string: Questionnaire global unique identifier (required)
   * body, QuestionnaireMetadata: Questionnaire metadata to update (required)
   * @return UpdateQuestionnaireResponse
	 */

   public function UpdateQuestionnaireMetadata($userId, $questionnaireId, $body) {
      if( $userId === null || $questionnaireId === null || $body === null ) {
        throw new ApiException("missing required parameters", 400);
      }
      //parse inputs
  	  $resourcePath = str_replace("*", "", "/merge/{userId}/questionnaires/{questionnaireId}/metadata");
  	  $resourcePath = str_replace("{format}", "json", $resourcePath);
  	  $method = "PUT";
      $queryParams = array();
      $headerParams = array();

      if($userId !== null) {
  			$resourcePath = str_replace("{" . "userId" . "}",
  			                            $userId, $resourcePath);
  		}
  		if($questionnaireId !== null) {
  			$resourcePath = str_replace("{" . "questionnaireId" . "}",
  			                            $questionnaireId, $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
      $response = $this->apiClient->callAPI($this->basePath, $resourcePath, $method,
  		                                      $queryParams, $body, $headerParams);
      if(! $response){
        return null;
      }

  	  $responseObject = $this->apiClient->deserialize($response,
  		                                                'UpdateQuestionnaireResponse');
  	  return $responseObject;
      }
  
}

