<!DOCTYPE html>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->
<head>
	
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-TSZZG4F');</script>
<!-- End Google Tag Manager -->

	<!-- Basic Page Needs
  =================================logo-wrapper================= -->
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php bloginfo('name'); ?>  <?php wp_title(); ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">

	<!--[if lt IE 9]>
		<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

	<!-- CSS
  ================================================== -->
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" />
	
	<?php global $gdl_is_responsive ?>
	<?php if( $gdl_is_responsive ){ ?>
		<meta name="viewport" content="width=device-width, user-scalable=no">
		<link rel="stylesheet" href="<?php echo GOODLAYERS_PATH; ?>/stylesheet/foundation-responsive.css">
	<?php }else{ ?>
		<link rel="stylesheet" href="<?php echo GOODLAYERS_PATH; ?>/stylesheet/foundation.css">
	<?php } ?>
	
	<!--[if IE 7]>
		<link rel="stylesheet" href="<?php echo GOODLAYERS_PATH; ?>/stylesheet/ie7-style.css" /> 
	<![endif]-->	
	
	<?php
	
		// start calling header script
		wp_head();

		// include favicon in the header
		if(get_option( THEME_SHORT_NAME.'_enable_favicon','disable') == "enable"){
			$gdl_favicon = get_option(THEME_SHORT_NAME.'_favicon_image');
			if( $gdl_favicon ){
				$gdl_favicon = wp_get_attachment_image_src($gdl_favicon, 'full');
				echo '<link rel="shortcut icon" href="' . $gdl_favicon[0] . '" type="image/x-icon" />';
			}
		} 
		
		// add facebook thumbnail to this page
		$thumbnail_id = get_post_thumbnail_id();
		if( !empty($thumbnail_id) ){
			$thumbnail = wp_get_attachment_image_src( $thumbnail_id , '150x150' );
			echo '<link rel="image_src" href="' . $thumbnail[0] . '" />';		
		}

	?>	
	
	
	
<!-- Facebook Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src=v;s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script',
  'https://connect.facebook.net/en_US/fbevents.js');
  fbq('init', '2709634622595336');
  fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
  src="https://www.facebook.com/tr?id=2709634622595336&ev=PageView&noscript=1"
/></noscript>
<!-- End Facebook Pixel Code -->

</head>
<style>
.InnerBannerBarBoxOne {
    display: inline-block;
    width: 100%;
    text-align: center;
    background-color: #a60407;
    padding-top: 20px;
    padding-bottom: 20px;
}
.InnerBannerBarBoxOne h1 {
    display: inline-block;
    width: 100%;
    text-align: center;
    background-color: #a60407;
    padding-top: 20px;
    padding-bottom: 20px;
    color: #fff;
    font-weight: 600;
    margin-bottom: 0;
}
.InnerBannerBarBoxOne p {
    display: inline-block;
    color: #dadada;
    font-size: 14px;
}
.InnerBannerBarBoxOne p:before {
    content: "\2713";
    margin-right: 5px;
    margin-left: 15px;
    font-family: FontAwesome;
    color: #fff;
    font-size: 20px;
    font-weight: 600;
}
    .ServiceBtn {
        text-align: center;
        padding-top: 100px;
        padding-bottom: 50px;
    }
    .Appointment {
        border: 2px solid #f00000;
        color: #000000;
        padding: 7px;
        width: 230px;
        display: inline-block;
        text-align: center;
        font-size: 19px;
        margin-right: 10px;
    }
    .Appointment:hover {
        background-color: #f00000;
        color: #fff;
    }
    .Question {
        border: 2px solid #f00000;
        color: #000000;
        padding: 7px;
        width: 230px;
        display: inline-block;
        text-align: center;
        font-size: 19px;
        margin-right: 10px;
    }
    .Question:hover {
        background-color: #f00000;
        color: #fff;
    }
    .CallBtn {
        border: 2px solid #f00000;
        color: #000000;
        padding: 7px;
        width: 230px;
        display: inline-block;
        text-align: center;
        font-size: 19px;
        margin-right: 10px;
    }
    .CallBtn:hover {
        background-color: #f00000;
        color: #fff;
    }
    ul.sf-menu li a {
        padding: 0px 22px;
    }
    .ContactPageForm {
        width: 93%;
        display: block;
        font-size: 17px;
        font-weight: 600;
    }
    .ContactPageForm span input {
        width: 100%;
        padding: 12px;
    }
    .ContactPageForm span textarea {
        width: 100%;
    }
    .ContactPageSubmit {
        border: 2px solid #0a951b;
        color: #000000 !important;
        padding: 7px !important;
        width: 230px;
        text-align: center;
        font-size: 19px !important;
        background-color: transparent !important;
        outline: none;
        border-width: 2px !important;
    }
    .BigWishesSection {
        margin-top: 50px;
        text-align: center;
    }
    .BigWishesSection h1 {
        text-align: center;
        font-size: 33px;
        font-weight: 600;
        margin-bottom: 40px;
    }
    .col-md-4 {
        width: 33%;
        display: inline-block;
        float: left;
    }
    .clearfix {
        clear: both;
    }
    .main01 {
        width: 250px;
        margin: 0px auto;
    }
    .main01 a img {
        width: 100%;
    }
    .main01 h3 {
        font-weight: 600;
        letter-spacing: 2px;
        line-height: 27px;
    }
    .main01 p {
        letter-spacing: 1px;
        line-height: 21px;
    }
    .responsive-menu-button {
        display: none !important;
    }
    
@media (min-width:320px) and (max-width:767px){
    .row .four {
        width: 100%;
    }
    .col-md-4 {
        width: 100%;
    }
    .gdl-navigation-wrapper {
        display: none;
    }
    .responsive-menu-button {
        display: block !important;
    }
    .ServiceBtn a {
        margin-bottom: 10px;
    }
    .InnerBannerBarBoxOne h1 {
        font-size: 22px;
    }
    .BigWishesSection h1 {
        font-size: 25px;
    }
    .row .eight {
        width: 100%;
    }
    .gdl-column-item iframe {
        width: 100%;
    }
    .wpcf7-form p {
        text-align: center;
    }
    .gdl-page-content div {
        height: auto !important;
    }
    .row .three {
        width: 100%;
    }
    .personnal-item {
        height: auto !important;
    }
}
@media (min-width:320px) and (max-width:992px){
    .gdl-column-item iframe {
        width: 100%;
    }
    .container {
        width: auto;
    }
    .row {
        width: auto;
        min-width: auto;
    }
    .nivo-caption {
        bottom: 3px;
    }
    h2.gdl-slider-title {
        font-size: 22px;
    }
    div.gdl-slider-caption {
        font-size: 11px;
    }
    div.top-navigation-wrapper {
        min-width: auto;
    }
    div.navigation-wrapper {
        padding: 0px 0px;
        height: auto;
    }
    div.footer-wrapper {
        min-width: auto;
    }
    div.footer-container {
        margin-top: 0;
    }
    div.copyright-left {
        float: none;
        text-align: center;
    }
    div.copyright-right {
        float: none;
        text-align: center;
    }
    #main-superfish-wrapper ul.sf-menu {
        display: block;
    }
    div.gdl-navigation-wrapper {
        background-color: #fff;
        margin-left: 10px;
        margin-right: 10px;
    }
    ul.sf-menu li a {
        padding: 0px 10px;
    }

    .alignnone, img.alignnone {
        margin: 5px 10px 20px 0;
    }

}
.logo-number{
    padding-bottom: 10px;
}
.logo-number a{
    color: #f00000;
    text-decoration: none;
    font-size: 30px;
    font-weight: bold;
}
.logo-number a span{
    color:#3b3b3b;
    padding-right: 6px;
}
</style>
<body <?php echo body_class(); ?>>

	<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TSZZG4F"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	
<?php
	// print custom background
	$background_style = get_option(THEME_SHORT_NAME.'_background_style', 'Pattern');
	if($background_style == 'Custom Image'){
		$background_id = get_option(THEME_SHORT_NAME.'_background_custom');
		$alt_text = get_post_meta($background_id , '_wp_attachment_image_alt', true);
		
		if(!empty($background_id)){
			$background_image = wp_get_attachment_image_src( $background_id, 'full' );
			echo '<div class="gdl-custom-full-background">';
			echo '<img src="' . $background_image[0] . '" alt="' . $alt_text . '" />';
			echo '</div>';
		}
	}
?>
<div class="body-wrapper">
	
	<?php // feedback button 
		$gdl_feedback_link = get_option(THEME_SHORT_NAME.'_feedback_button_link');
		if( $gdl_feedback_link ){
			echo '<div class="feedback-wrapper">';
			echo '<a href="' . do_shortcode( __($gdl_feedback_link, 'gdl_front_end') ) . '" target="_blank">';
			echo get_option(THEME_SHORT_NAME.'_feedback_button_text');
			echo '</a>';
			echo '</div>';
		}	
	?>
	
	<?php $gdl_enable_top_navigation = get_option(THEME_SHORT_NAME.'_enable_top_navigation'); ?>
	<?php if ( $gdl_enable_top_navigation == '' || $gdl_enable_top_navigation == 'enable' ){  ?>
		<div class="top-navigation-wrapper">
			<div class="top-navigation container">
				<?php
					// get top navigation left text
					$top_navigation_left_text = do_shortcode( __(get_option(THEME_SHORT_NAME.'_top_navigation_left_text'), 'gdl_front_end') );
					if( !empty($top_navigation_left_text) ){
						echo '<div class="top-navigation-left">' . $top_navigation_left_text . '</div>';
					}		
				?>
				
				<div class="top-navigation-right">
					<!-- Get Social Icons -->
					<div id="gdl-social-icon" class="social-wrapper">
						<div class="social-icon-wrapper">
							<?php
								global $gdl_icon_type;
								$gdl_social_icon = array(
									'delicious'=> array('name'=>THEME_SHORT_NAME.'_delicious', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/delicious.png'),
									'deviantart'=> array('name'=>THEME_SHORT_NAME.'_deviantart', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/deviantart.png'),
									'digg'=> array('name'=>THEME_SHORT_NAME.'_digg', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/digg.png'),
									'facebook' => array('name'=>THEME_SHORT_NAME.'_facebook', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/facebook.png'),
									'flickr' => array('name'=>THEME_SHORT_NAME.'_flickr', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/flickr.png'),
									'lastfm'=> array('name'=>THEME_SHORT_NAME.'_lastfm', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/lastfm.png'),
									'linkedin' => array('name'=>THEME_SHORT_NAME.'_linkedin', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/linkedin.png'),
									'picasa'=> array('name'=>THEME_SHORT_NAME.'_picasa', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/picasa.png'),
									'rss'=> array('name'=>THEME_SHORT_NAME.'_rss', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/rss.png'),
									'stumble-upon'=> array('name'=>THEME_SHORT_NAME.'_stumble_upon', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/stumble-upon.png'),
									'tumblr'=> array('name'=>THEME_SHORT_NAME.'_tumblr', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/tumblr.png'),
									'twitter' => array('name'=>THEME_SHORT_NAME.'_twitter', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/twitter.png'),
									'vimeo' => array('name'=>THEME_SHORT_NAME.'_vimeo', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/vimeo.png'),
									'youtube' => array('name'=>THEME_SHORT_NAME.'_youtube', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/youtube.png'),
									'google_plus' => array('name'=>THEME_SHORT_NAME.'_google_plus', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/google-plus.png'),
									'email' => array('name'=>THEME_SHORT_NAME.'_email', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/email.png'),
									'pinterest' => array('name'=>THEME_SHORT_NAME.'_pinterest', 'url'=> GOODLAYERS_PATH.'/images/icon/social-icon/pinterest.png')
								);
								
								foreach( $gdl_social_icon as $social_name => $social_icon ){
									$social_link = get_option($social_icon['name']);
									
									if( !empty($social_link) ){
										echo '<div class="social-icon"><a target="_blank" href="' . $social_link . '">' ;
										echo '<img src="' . $social_icon['url'] . '" alt="' . $social_name . '"/>';
										echo '</a></div>';
									}
								}
							?>
						</div> <!-- social icon wrapper -->
					</div> <!-- social wrapper -->	

				</div> <!-- top navigation right -->
				
				<div class="clear"></div>
			</div> <!-- top navigation container -->
			<div class="top-navigation-wrapper-gimmick"></div>
		</div> <!-- top navigation wrapper -->
	<?php } ?> 

	<div class="header-wrapper container">
			
		<!-- Get Logo -->
		<div class="logo-wrapper">
			<?php
				$logo_id = get_option(THEME_SHORT_NAME.'_logo');
				if( empty($logo_id) ){	
					$alt_text = 'default-logo';	
					$logo_attachment = GOODLAYERS_PATH . '/images/default-logo.png';
				}else{
					$alt_text = get_post_meta($logo_id , '_wp_attachment_image_alt', true);	
					$logo_attachment = wp_get_attachment_image_src($logo_id, 'full');
				}

				if( is_front_page() ){
					echo '<h1><a href="' . home_url( '/' ) . '">';
					echo '<img src="' . $logo_attachment[0] . '" alt="' . $alt_text . '"/>';
					echo '</a></h1>';					
				}else{
					echo '<a href="' . home_url( '/' ) . '">';
					echo '<img src="' . $logo_attachment[0] . '" alt="' . $alt_text . '"/>';
					echo '</a>';
				}
			?>
			<div class="logo-number">
			    <a href="teL:9058241426"><span>call us today at:</span>905-824-1426</a>
			</div>
		</div>
		<?php
			// Logo right text
			if( get_option(THEME_SHORT_NAME . '_logo_position') != 'Center' ){
				echo '<div class="logo-right-text">';
				echo do_shortcode( __(get_option(THEME_SHORT_NAME . '_logo_right_text'), 'gdl_front_end') );
				echo '</div>';
			}
		?>

		<!-- Navigation -->
		<div class="clear"></div>
		<div class="gdl-navigation-wrapper">
			<?php 
				// responsive menu
				if( $gdl_is_responsive ){
					dropdown_menu( array('dropdown_title' => '-- Main Menu --', 'indent_string' => '- ', 'indent_after' => '','container' => 'div', 'container_class' => 'responsive-menu-wrapper', 'theme_location'=>'main_menu') );	
				}
				
				// main menu
				echo '<div class="navigation-wrapper">';
				wp_nav_menu( array('container' => 'div', 'container_class' => 'menu-wrapper', 'container_id' => 'main-superfish-wrapper', 'menu_class'=> 'sf-menu',  'theme_location' => 'main_menu' ) );
				echo '</div>';
			?>
			
			<!-- search form -->
			<div class="top-search-form">
				<div class="gdl-search-button" id="gdl-search-button"></div> 
				<div class="search-wrapper">
					<div class="gdl-search-form">
						<form method="get" id="searchform" action="<?php  echo home_url(); ?>/">
							<?php
								$search_val = get_search_query();
								if( empty($search_val) ){
									$search_val = __("Search..." , "gdl_front_end");
								}
							?>
							<div class="search-text">
								<input type="text" value="<?php echo $search_val; ?>" name="s" id="s" autocomplete="off" data-default="<?php echo $search_val; ?>" />
							</div>
							<input type="submit" id="searchsubmit" value="<?php _e("Go!", "gdl_front_end") ?>" />
							<div class="clear"></div>
						</form>
					</div>
				</div>		
			</div>		
			<div class="clear"></div>
		</div>
		
	</div> <!-- header wrapper container -->
	
	<div class="content-wrapper container">

		