<?php get_header(); ?>
	<?php
		// Check and get Sidebar Class
		$sidebar = get_post_meta($post->ID,'post-option-sidebar-template',true);
		$sidebar_array = gdl_get_sidebar_size( $sidebar );

		// Translator words
		global $gdl_admin_translator;	
		if( $gdl_admin_translator == 'enable' ){
			$translator_tag = get_option(THEME_SHORT_NAME.'_translator_tags', 'Tags: ');
			$translator_client = get_option(THEME_SHORT_NAME.'_translator_client', 'Client: ');
			$translator_skill = get_option(THEME_SHORT_NAME.'_translator_skill', 'Skill: ');
			$translator_visit_website = get_option(THEME_SHORT_NAME.'_translator_visit_website', 'Visit Website: ');
			$translator_related_portfolio = get_option(THEME_SHORT_NAME.'_translator_related_portfolio', 'Related Portfolio');
			
			$translator_about_author = get_option(THEME_SHORT_NAME.'_translator_about_author', 'About the Author');
			$translator_social_share = get_option(THEME_SHORT_NAME.'_translator_social_shares', 'Social Share');
		}else{
			$translator_tag = __('Tags: ','gdl_front_end');
			$translator_client =  __('Client: ','gdl_front_end');
			$translator_skill =  __('Skill: ','gdl_front_end');
			$translator_visit_website = __('Visit Website: ','gdl_front_end');	
			$translator_related_portfolio = get_option(THEME_SHORT_NAME.'_translator_related_portfolio', 'Related Portfolio');	
			
			$translator_about_author = __('About the Author','gdl_front_end');
			$translator_social_share = __('Social Share','gdl_front_end');
		}		
		
		// related portfolio check
		$related_portfolio = get_option( THEME_SHORT_NAME.'_gdl_related_portfolio' ,'Yes');
		$related_portfolio_class = ($related_portfolio == 'Yes')? 'mb0' : '';
		
	?>
	<div class="page-wrapper single-portfolio <?php echo $sidebar_array['sidebar_class']; ?> ">
		<?php
			$left_sidebar = get_post_meta( $post->ID , "post-option-choose-left-sidebar", true);
			$right_sidebar = get_post_meta( $post->ID , "post-option-choose-right-sidebar", true);		
			
			$current_page_style = get_option(THEME_SHORT_NAME.'_use_portfolio_as', 'portfolio style');
			if( $current_page_style == 'portfolio style' ){
				global $port_single_size, $sidebar_type;
				$item_size = $port_single_size[$sidebar_type];
				$single_title = get_the_title();
			}else{
				global $blog_single_size, $sidebar_type;
				$item_size = $blog_single_size[$sidebar_type];	
				$single_title = get_post_meta( $post->ID, "post-option-blog-header-title", true);
				if(empty( $single_title )){
					$single_title = get_option(THEME_SHORT_NAME . '_default_post_header','Single Blog');
				}				
			}

			// portfolio title
			print_page_header($single_title);
			
			// starting the content
			echo '<div class="row">';
			echo '<div class="gdl-page-left  mb0 ' . $sidebar_array['page_left_class'] . '">';
			
			echo '<div class="row">';
			echo '<div class="gdl-page-item  mb20 gdl-blog-full ' . $sidebar_array['page_item_class'] . '">';
			echo '<div class="gdl-single-portfolio ' . $related_portfolio_class . '">';
			if (have_posts()){
				while (have_posts()){
					the_post();
					if( $current_page_style == 'portfolio style' ){
						print_single_port_thumbnail( get_the_ID(), $item_size );
						
						echo '<div class="port-content-wrapper">';
						echo '<div class="port-info-wrapper">';
						
						// navigation
						echo '<div class="port-nav">';
						next_post_link('<div class="port-prev-nav">%link</div>', '', true);
						previous_post_link('<div class="port-next-nav">%link</div>', '', true);
						echo '<div class="clear"></div>';
						echo '</div>'; 
						
						// client
						$client_name = get_post_meta($post->ID, 'post-option-clients-name', true);
						if(!empty($client_name)){
							echo '<div class="port-client port-info"><span class="head">' . $translator_client . '</span>';
							echo $client_name;
							echo '</div>';
						}	

						// skill
						$skill_val = get_post_meta($post->ID, 'post-option-skill-value', true);
						if(!empty($skill_val)){
							echo '<div class="port-skill port-info"><span class="head">' . $translator_skill . '</span>';
							echo $skill_val;
							echo '</div>';
						}						
						
						// tags
						$portfolio_tag = get_the_term_list( $post->ID, 'portfolio-tag', '', ', ' , '' );
						if(!empty($portfolio_tag)){
						echo '<div class="port-tags port-info"><span class="head">' . $translator_tag . '</span>';
						echo $portfolio_tag;
						echo '</div>';
						}
						
						// visit website
						$website_link = get_post_meta( $post->ID, 'post-option-website-url', true); 
						if(!empty($website_link)){
							echo '<div class="port-visit-website port-info"><span class="head">' . $translator_visit_website . '</span>';
							echo '<a href="' . $website_link . '" target="_blank" >' . $website_link . '</a>';
							echo '</div>';
						}						
						
						echo '</div>'; // port info
						
						echo '<div class="port-content">';
						the_content();
						wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', 'gdl_front_end' ) . '</span>', 'after' => '</div>' ) );
						echo '</div>';
						echo '</div>'; // port content wrapper
						echo '<div class="clear"></div>';
					}else{
					
					}
				}
			}
			
			// print related portfolio
			if( $related_portfolio == 'Yes' ){
				echo '<div class="gdl-related-portfolio">';
				$port_size = get_option( THEME_SHORT_NAME.'_gdl_related_portfolio_size' , '1/4');
				$num_fetch = get_option( THEME_SHORT_NAME.'_gdl_related_portfolio_num_fetch' , 4);
				$show_title = (get_option( THEME_SHORT_NAME.'_gdl_related_portfolio_title' , 'Yes') == 'Yes') ? true: false;
				$show_tag = (get_option( THEME_SHORT_NAME.'_gdl_related_portfolio_tag' , 'Yes') == 'Yes') ? true: false;
				
				print_item_header( $translator_related_portfolio );
				
				$portfolio_tags = get_the_terms(get_the_ID(), 'portfolio-tag');
				$portfolio_terms = array();
				foreach( $portfolio_tags as $portfolio_tag ){
					$portfolio_terms[] = $portfolio_tag->slug;
				}
				
				$tax_query = array( array('taxonomy'=>'portfolio-tag', 'field'=>'slug', 'terms'=>$portfolio_terms) );
				query_posts(array('post_type'=>'portfolio', 'tax_query'=>$tax_query, 'posts_per_page'=>$num_fetch));
				
				print_normal_portfolio($port_size, $show_title, $show_tag);
				
				echo '<div class="clear"></div>';
				echo '</div>'; // gdl-related-portfolio
			}
			echo '</div>'; // gdl-single-portfolio
			
			wp_reset_query();
			
			echo "</div>"; // end of gdl-page-item
			
			get_sidebar('left');	
			echo '<div class="clear"></div>';			
			echo "</div>"; // row
			echo "</div>"; // gdl-page-left

			get_sidebar('right');
			echo '<div class="clear"></div>';
			echo "</div>"; // row
		?>
		<div class="clear"></div>
	</div> <!-- page wrapper -->

<?php get_footer(); ?>